---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-kubeadm token

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `cmd/kubeadm/app/cmd/token.go` - tokenコマンド本体
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 4つのサブコマンド（create, list, delete, generate） | E-01 行146-201 AddCommand | ○ |
| C-02 | createでトークンをSecretとして作成 | E-01 行250 tokenphase.CreateNewTokens | ○ |
| C-03 | --print-join-commandでjoinコマンド出力 | E-01 行256-275 | ○ |
| C-04 | --certificate-keyは--print-join-commandと同時にのみ使用可能 | E-01 行277-279 | ○ |
| C-05 | listでtype=bootstrap.kubernetes.io/tokenのSecretを検索 | E-01 行365-372 | ○ |
| C-06 | deleteで1つ以上の引数が必須 | E-01 行189-191 | ○ |
| C-07 | deleteでトークンIDまたはフルトークンを受け付ける | E-01 行411-421 | ○ |
| C-08 | generateはサーバアクセスなし | E-01 行222-226 RunE内でサーバ呼び出しなし | ○ |
| C-09 | DryRunモードでDeleteBootstrapTokenReactor使用 | E-01 行437-438 | ○ |
| C-10 | list出力列：TOKEN, TTL, EXPIRES, USAGES, DESCRIPTION, EXTRA GROUPS | E-01 行356 | ○ |
| C-11 | トークン形式 [a-z0-9]{6}.[a-z0-9]{16} | E-01 行77, 109 | ○ |
| C-12 | Secret名は bootstrap-token-<id> | E-01 行423 BootstrapTokenSecretName | ○ |
| C-13 | 関連機能118-クラスター初期化が補助機能 | E-03 画面No48 | ○ |
| C-14 | 関連機能2-認証がAPI連携 | E-03 画面No48 | ○ |
| C-15 | --kubeconfig永続フラグが共通 | E-01 行86 PersistentFlags | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから主要な処理フローが明確に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] tokenphase.CreateNewTokensの実装詳細を確認
- [ ] デフォルトのusagesとgroupsの値が正確か確認
- [ ] joinコマンド生成ロジック（cmdutil.GetJoinWorkerCommand等）を確認
